package rtbOjbects

import 	"alpha/adDelivery/structure"
import 	"strconv"
import 	"strings"
import "time"
import "fmt"
import	"github.com/elliotchance/phpserialize"




func GetId() string {
	
	return strconv.Itoa(int(time.Now().UnixNano() / int64(time.Millisecond)))
}


func GetDspObj(zninfo structure.ZoneInfo, znextra structure.AdExchangeZone,buyer_details []structure.ExchangeDetails ) [] structure.DspObjects { 
	 
	 	var dspObjs []structure.DspObjects
	 	
	for _,buyer := range buyer_details {
		
		var dspObj structure.DspObjects
		dspObj.Id = buyer.Exchange_id
		if buyer.Open_rtb_version == "1" {
		dspObj.Ver = "2.4" 
		} else if buyer.Open_rtb_version == "2" {
			dspObj.Ver = "2.3"
		} else if buyer.Open_rtb_version == "3" {
			dspObj.Ver = "2.2"
		} else if buyer.Open_rtb_version == "4" {
			dspObj.Ver = "2.5"
		} else if buyer.Open_rtb_version == "5" {
			dspObj.Ver = "3.0"
		}
		
		if buyer.Auction_currency == 0 {
		dspObj.Cur = []string{"USD"}
		}
		dspObj.Ping_url = buyer.Ping_url
		dspObj.At = buyer.Auction_type
		dspObj.Gzip = buyer.Gzip
		dspObj.Source =  structure.DspObjects__source{Ts: int(time.Now().UnixNano() / int64(time.Millisecond)) ,Ds : buyer.Digital_signature }
		
		
		  
	dspObjs = append(dspObjs,dspObj)
	
	
	}
	
		
	 return dspObjs
	
}



func GetImpImgObj(zninfo structure.ZoneInfo, znextra structure.AdExchangeZone ,deals []structure.DealsDetails ) [] structure.ImpImgObjects {
	 
	impObj := structure.ImpImgObjects{}
	
	impObj.Id = "1"
	impObj.Bidfloor = znextra.Imp_bidfloor
	
	var mimes [] string
	
	if(zninfo.Delivery == "3") {
		mimes = append(mimes,"text/plain")
		zninfo.Width = 300
		zninfo.Height = 250
	} 	else	{
		 
		mimes =  strings.Split(znextra.Ban_mimes, ",") 
		
		//~ mimes = append(mimes,"image/jpg")
		//~ mimes = append(mimes,"image/gif")
		//~ mimes = append(mimes,"image/png")
		//~ mimes = append(mimes,"image/jpeg")
		//~ mimes = append(mimes,"text/html")
	} 
	
	
	impObj.Banner = structure.ImpObjects__banner{W:zninfo.Width, H:zninfo.Height, Pos : 0 , Mimes :mimes}

	if (zninfo.Inv_type == 2 ||  zninfo.Inv_type == 3) && len(deals) > 0 { 
		 
		 impdeals := []structure.ImpObjects__pmp__deals{}
		for _,deal := range deals { 
			
			impdeal := structure.ImpObjects__pmp__deals{ Id: deal.Dealid_token , At: deal.Auction_type , Bidfloor : deal.Floor_price , Wseat : strings.Split(deal.Whitelist , ",")    }
			impdeals = append(impdeals,impdeal)
		}
		
		impObj.Pmp = structure.ImpObjects__pmp { Private_auction :1 , Deals : impdeals  } 
		
	}
	

	var impObjs []structure.ImpImgObjects
	impObjs = append(impObjs,impObj	)
	
		
	return impObjs
	
}

func GetImpVidObj(zninfo structure.ZoneInfo, znextra structure.AdExchangeZone ,deals []structure.DealsDetails ,protocal int) [] structure.ImpVideoObjects {
	 
	impObj := structure.ImpVideoObjects{}
	
		impObj.Id = "1"
		
		var linearity int
		
		if zninfo.Delivery == "6" {
				
				linearity = 1
				
			} else if zninfo.Delivery == "7" {
				
				linearity = 2
			}
			
			
	impObj.Bidfloor = znextra.Imp_bidfloor
	
	impObj.Video = structure.ImpObjects__video{}
	
	impObj.Video.W = znextra.Vid_width
	impObj.Video.H = znextra.Vid_height
	impObj.Video.Pos = znextra.Vid_pos
	//~ impObj.Video.Startdelay = znextra.Startdelay
	impObj.Video.Minduration = znextra.Vid_min
	impObj.Video.Maxduration = znextra.Vid_max 
	impObj.Video.Maxextended = znextra.Vid_maxext 
	impObj.Video.Minbitrate = znextra.Vid_minbit 
	impObj.Video.Maxbitrate = znextra.Vid_maxbit 
	impObj.Video.Api = StringToIntArr(znextra.Vid_api)
	if protocal != 0 {
		impObj.Video.Protocols = []int {protocal}
	} else {
	impObj.Video.Protocols = []int {1,2,3,4,5,6,7,8,9,10,11,12}
	}
	impObj.Video.Mimes = strings.Split(znextra.Vid_mimes, ",")
	impObj.Video.Linearity = linearity
	impObj.Video.Boxingallowed = znextra.Vid_box
	impObj.Video.Playbackmethod = StringToIntArr(znextra.Vid_play)
	impObj.Video.Delivery = []int{znextra.Vid_del} 
	impObj.Video.Battr = StringToIntArr(znextra.Vid_battr) 
	
	
	Companionads := []structure.ImpObjects__video__companionad{}
	Companionad := structure.ImpObjects__video__companionad{}
	 
	Companionad.Id = "1"
	Companionad.W = znextra.Vid_comp_width
	Companionad.H = znextra.Vid_comp_height
	
	
	Companionads = append(Companionads,Companionad)
	impObj.Video.Companionad = Companionads
	impObj.Video.Companiontype =StringToIntArr(znextra.Vid_comptype) 

	if (zninfo.Inv_type == 2 ||  zninfo.Inv_type == 3) && len(deals) > 0 { 
		 
		 impdeals := []structure.ImpObjects__pmp__deals{}
		for _,deal := range deals { 
			
			impdeal := structure.ImpObjects__pmp__deals{ Id: deal.Dealid_token , At: deal.Auction_type , Bidfloor : deal.Floor_price , Wseat : strings.Split(deal.Whitelist , ",")    }
			impdeals = append(impdeals,impdeal)
		}
		
		impObj.Pmp = structure.ImpObjects__pmp { Private_auction :1 , Deals : impdeals  } 
		
	}
	

	var impObjs []structure.ImpVideoObjects
	impObjs = append(impObjs,impObj	)
		
		
		
	return impObjs
	
}




func GetSiteObj(zninfo structure.ZoneInfo, znextra structure.AdExchangeZone,glob structure.GlobalVariables)  structure.SiteObjects {
	
	siteObj := structure.SiteObjects{}
	siteObj.Id = strconv.Itoa( zninfo.Zoneid)

	siteObj.Name = glob.DomainName
	siteObj.Domain = znextra.Pub_domain
	siteObj.Page = glob.PageURL 
	siteObj.Pagecat = strings.Split(znextra.Site_page , ",")  

	
	
	// Mobile , amp needs to add
	
	return siteObj
	
}


func GetDeviceObj(zninfo structure.ZoneInfo, znextra structure.AdExchangeZone,glob structure.GlobalVariables)  structure.DeviceObjects {
	
		deviceObj := structure.DeviceObjects{}

	if znextra.Dev_dnt == 0 {
	
	deviceObj.Ip = glob.Ip_address
	deviceObj.Ua = glob.Useragent
	deviceObj.Make = glob.DeviceName
	deviceObj.Model = glob.DeviceModel
	
	switch (glob.DeviceType) {
		case "Computer" :
			deviceObj.Devicetype =	2
		case "Phone" :
			deviceObj.Devicetype =	1
		case "Tablet" :
			deviceObj.Devicetype =	5
		case "Tv" :
			deviceObj.Devicetype =	3
		case "Console" :
			deviceObj.Devicetype =	7
		default :
		deviceObj.Devicetype =	2 
		
	}
	
	
	deviceObj.Os = glob.Os
	deviceObj.Osv = glob.Osv 
		
	}
			return deviceObj
	
}


func GetGeoObj(zninfo structure.ZoneInfo, znextra structure.AdExchangeZone,glob structure.GlobalVariables)  structure.DeviceObjects__geo {
	
	geoObj := structure.DeviceObjects__geo{}

	geoObj.Type = 1
	geoObj.Lat, _ = strconv.ParseFloat(glob.Latitude, 64)
	geoObj.Lon, _ = strconv.ParseFloat(glob.Longitude, 64)
	
	geoObj.Country = glob.Country_code
	
	return geoObj
	
}


func GetUserObj(zninfo structure.ZoneInfo, znextra structure.AdExchangeZone,glob structure.GlobalVariables)  structure.UserObjects {
	
	userObj := structure.UserObjects{}
	
	userObj.Buyeruid = znextra.User_bid
	
	if znextra.User_yob > 0 {
	userObj.Yob = znextra.User_yob
	}
	
	if znextra.User_gender != "" {
	userObj.Gender = znextra.User_gender
	}
	
		
	return userObj
	
}

func GetRegObj(zninfo structure.ZoneInfo, znextra structure.AdExchangeZone,glob structure.GlobalVariables)  structure.RegsObjects {
	
	regsObj := structure.RegsObjects{}
	
	regsObj.Coppa = 1
	
		
	return regsObj
	
}


func StringToIntArr(A string) []int {
 a := strings.Split(A, ",")
 var b []int
 for _,v := range a {
		vv,_ := strconv.Atoi(v)
		b = append(b,vv)
	}
 return b
}



func GetVideoNativeObj(zninfo structure.ZoneInfo, znextra structure.AdExchangeZone ,deals []structure.DealsDetails ) [] structure.ImpNativeObjects {
	 
	NativeObj := structure.ImpNativeObjects{}
	
	NativeObj.Id = "1"
	NativeObj.Bidfloor = znextra.Imp_bidfloor
	

	var native_ob map[interface{}]interface{}
	phpserialize.Unmarshal([]byte(znextra.Native_objects), &native_ob)
	
	var nat_assets[]interface{}
	
	nat_ad_title :=  fmt.Sprintf("%v", native_ob["ad_title"])
	nat_ad_title_length,_ := strconv.Atoi(fmt.Sprintf("%v", native_ob["adtitle_length"]))
	nat_ad_desc_length,_ := strconv.Atoi(fmt.Sprintf("%v", native_ob["desc_length"]))
	nat_ad_data_objects := fmt.Sprintf("%v", native_ob["data_objects"])
	nat_ad_img_types := fmt.Sprintf("%v", native_ob["nativeimgs"])
	

	if nat_ad_title == "on" {
		native_title_object :=  structure.Nativeobj_assetsTitle{
									Id : 1 , 
									Title : structure.Nativeobj_assetsTitle_details { Lens : 	nat_ad_title_length},
															}
		nat_assets = append(nat_assets,native_title_object)
	}
	
	 
	
	nat_ad_img_types_arr := strings.Split(nat_ad_img_types, ",")
		
	for _,img_types := range nat_ad_img_types_arr {	
	
	if img_types == "icon" {
		native_icon_object :=  structure.Nativeobj_assetsImg{
									Id : 2 , 
									Img : structure.Nativeobj_assetsImg_Details { Type : 1 },
															}
		nat_assets = append(nat_assets,native_icon_object)
		
	}
		
		
		
		
			nv := structure.ImpObjects__video{} 

	nv.Pos = znextra.Vid_pos
	nv.Minduration = znextra.Vid_min
	nv.Maxduration = znextra.Vid_max 
	nv.Maxextended = znextra.Vid_maxext 
	nv.Minbitrate = znextra.Vid_minbit 
	nv.Maxbitrate = znextra.Vid_maxbit 
	nv.Api = StringToIntArr(znextra.Vid_api)
	nv.Protocols = []int {1,2,3,4,5,6,7,8,9,10,11,12}
	nv.Mimes = strings.Split(znextra.Vid_mimes, ",")
	nv.Linearity = 1
		
		  
		native_main_object :=  structure.Nativeobj_assetsVideo{
									Id : 3 , 
									Video : nv ,
															}
															
															
															
		nat_assets = append(nat_assets,native_main_object)
		
		
	// video setup 
	
	}
	
	default_dataTypes  := make( map[string]int )
	default_dataTypes["dj_data_sponsored"] = 1
	default_dataTypes["dj_data_desc"] = 2
	default_dataTypes["dj_data_rating"] = 3
	default_dataTypes["dj_data_likes"] = 4
	default_dataTypes["dj_data_downloads"] = 5
	default_dataTypes["dj_data_price"] = 6
	default_dataTypes["dj_data_salesprice"] = 7
	default_dataTypes["dj_data_phoneno"] = 8
	default_dataTypes["dj_data_address"] = 9
	default_dataTypes["dj_data_desc2"] = 10
	default_dataTypes["dj_data_displayurl"] = 11
	default_dataTypes["dj_data_ctatext"] = 12
	
	
		
		nat_ad_data_types_arr := strings.Split(nat_ad_data_objects, ",")


		for _,data_type := range nat_ad_data_types_arr {	
			
			
			if data_type == "dj_data_desc" {
				
				native_data_object :=  structure.Nativeobj_assetsData{
									Id : default_dataTypes[data_type] + 3 , 
									Data : structure.Nativeobj_assetsData_details { Type : default_dataTypes[data_type] , Len : nat_ad_desc_length  },
															}
			nat_assets = append(nat_assets,native_data_object)
				
			} else 
			{
				
					
				native_data_object :=  structure.Nativeobj_assetsData{
									Id : default_dataTypes[data_type] + 3 , 
									Data : structure.Nativeobj_assetsData_details { Type : default_dataTypes[data_type] },
															}
			nat_assets = append(nat_assets,native_data_object)
		}
			
			
			
			
			
		}
 
	 
	 
	 NativeObj.Natives = structure.Nativeobj_details{ NativeReq : structure.NativeRequests{ Assets :nat_assets  }}
	
	
	

	var NativeObjs []structure.ImpNativeObjects
	NativeObjs = append(NativeObjs,NativeObj	)
	
		
	return NativeObjs
	
}


func GetImpNativeObj(zninfo structure.ZoneInfo, znextra structure.AdExchangeZone ,deals []structure.DealsDetails ) [] structure.ImpNativeObjects {
	 
	NativeObj := structure.ImpNativeObjects{}
	
	NativeObj.Id = "1"
	NativeObj.Bidfloor = znextra.Imp_bidfloor
	

	var native_ob map[interface{}]interface{}
	phpserialize.Unmarshal([]byte(znextra.Native_objects), &native_ob)
	
	var nat_assets[]interface{}
	
	nat_ad_title :=  fmt.Sprintf("%v", native_ob["ad_title"])
	nat_ad_title_length,_ := strconv.Atoi(fmt.Sprintf("%v", native_ob["adtitle_length"]))
	nat_ad_desc_length,_ := strconv.Atoi(fmt.Sprintf("%v", native_ob["desc_length"]))
	nat_ad_img_width,_ :=  strconv.Atoi(fmt.Sprintf("%v", native_ob["img_width"]))
	nat_ad_img_height ,_:= strconv.Atoi( fmt.Sprintf("%v", native_ob["img_height"]))
	nat_ad_data_objects := fmt.Sprintf("%v", native_ob["data_objects"])
	nat_ad_img_types := fmt.Sprintf("%v", native_ob["nativeimgs"])
	

	if nat_ad_title == "on" {
		native_title_object :=  structure.Nativeobj_assetsTitle{
									Id : 1 , 
									Title : structure.Nativeobj_assetsTitle_details { Lens : 	nat_ad_title_length},
															}
		nat_assets = append(nat_assets,native_title_object)
	}
	
	
	
	nat_ad_img_types_arr := strings.Split(nat_ad_img_types, ",")
		
	for _,img_types := range nat_ad_img_types_arr {	
	
	if img_types == "icon" {
		native_icon_object :=  structure.Nativeobj_assetsImg{
									Id : 2 , 
									Img : structure.Nativeobj_assetsImg_Details { Type : 1 },
															}
		nat_assets = append(nat_assets,native_icon_object)
		
	} else if img_types == "main" {
		
		native_main_object :=  structure.Nativeobj_assetsImg{
									Id : 3 , 
									Img : structure.Nativeobj_assetsImg_Details { Type : 3 , W : nat_ad_img_width , H:nat_ad_img_height },
															}
		nat_assets = append(nat_assets,native_main_object)
	}
	
	}
	
	default_dataTypes  := make( map[string]int )
	default_dataTypes["dj_data_sponsored"] = 1
	default_dataTypes["dj_data_desc"] = 2
	default_dataTypes["dj_data_rating"] = 3
	default_dataTypes["dj_data_likes"] = 4
	default_dataTypes["dj_data_downloads"] = 5
	default_dataTypes["dj_data_price"] = 6
	default_dataTypes["dj_data_salesprice"] = 7
	default_dataTypes["dj_data_phoneno"] = 8
	default_dataTypes["dj_data_address"] = 9
	default_dataTypes["dj_data_desc2"] = 10
	default_dataTypes["dj_data_displayurl"] = 11
	default_dataTypes["dj_data_ctatext"] = 12
	
	
		
		nat_ad_data_types_arr := strings.Split(nat_ad_data_objects, ",")


		for _,data_type := range nat_ad_data_types_arr {	
			
			
			if data_type == "dj_data_desc" {
				
				native_data_object :=  structure.Nativeobj_assetsData{
									Id : default_dataTypes[data_type] + 3 , 
									Data : structure.Nativeobj_assetsData_details { Type : default_dataTypes[data_type] , Len : nat_ad_desc_length  },
															}
			nat_assets = append(nat_assets,native_data_object)
				
			} else 
			{
				
					
				native_data_object :=  structure.Nativeobj_assetsData{
									Id : default_dataTypes[data_type] + 3 , 
									Data : structure.Nativeobj_assetsData_details { Type : default_dataTypes[data_type] },
															}
			nat_assets = append(nat_assets,native_data_object)
		}
			
			
			
			
			
		}
 
	 
	 
	 NativeObj.Natives = structure.Nativeobj_details{ NativeReq : structure.NativeRequests{ Assets :nat_assets  }}
	fmt.Println(nat_assets) 
	
	

	var NativeObjs []structure.ImpNativeObjects
	NativeObjs = append(NativeObjs,NativeObj	)
	
		
	return NativeObjs
	
}



